;; PShell by Abdu
;;

;=======Misc sprite tables defines=======

!SpriteDir				= !157C
!DisableContact			= !154C
!StunTimer				= !1540
;========================================

;=======Changeable values defines========
!DisableContactFrames	= $10
!GFXTile 				= $42
!SmushedGFXTile 		= #$FE
;========================================

print "INIT", pc
	LDA #$09
	STA !14C8,x
RTL

; this is not used rn but kept in for future use.
print "MAIN", pc
	; PHB : PHK : PLB
	; LDA #$09
	; STA !14C8,x
	; JSR Graphics
	; PLB
RTL

POWMain:
	lda !163E,x
	beq .notPressed
	cpy #$01
	bne .pressed
	lda #$04
	sta !14C8,x
	lda #$1F
	sta !1540,x
	rts
	.pressed
	jsr SmushedGFX
	rts

	.notPressed
	lda #$01
	sta !157C,x
	jsr Graphics

rts

print "CARRIABLE", pc
	JSR Carriable
RTL

Carriable:
	LDA $9D
	BNE .draw
	JSL $01802A|!bank 		; update X and Y position, interact with objects and apply gravity.
	JSR IsOnGround
	BEQ .inAir
	JSR Bounce

	.inAir
	JSR IsTouchingCeiling
	BEQ .noCeiling

	LDA #$10				; set Y speed whenever the sprite is touching a ceiling.
	STA !AA,x				;
	JSR IsTouchingObjSide
	BNE .noCeiling
	LDA !E4,x : CLC : ADC #$08 : STA $9A
	LDA !14E0,x : ADC #$00 : STA $9B
	
	LDA !D8,x : AND #$F0 : STA $98
	LDA !14D4,x : STA $99

	LDA !1588,x						;\
	AND #$20						;|
	ASL #3							;|
	ROL								;|
	AND #$01						;| Activate block
	STA $1933|!addr					;|
	LDY #$00						;|
	LDA $1868|!addr					;|
	JSL $00F160|!bank				;/
	LDA #$08						;
	STA !1FE2,x

	.noCeiling
	JSR IsTouchingObjSide
	BEQ .noSide

	JSR InteractSideBlock		; interact with the side of the block.
	LDA !B6,x
	ASL
	PHP
	ROR !B6,x
	PLP
	ROR !B6,x
	.noSide
	JSR InteractionCarriable
	
	.draw
	JSR POWMain
	; LDA #$00			;\ POWs don't need this I think.
	; %SubOffScreen()		;/
RTS

InteractionCarriable:
	JSL $01803A|!bank		; interact with player and other sprites.
	BCC .Ret

	LDA !DisableContact,x
	BNE .Ret

	LDA $15				;\ check if X/Y are presed
	AND #$40			;|
	BEQ .noCarry		;/

	LDA $1470|!addr		;\ Carrying something or on yoshi.
	ORA $187A|!addr		;|
	BNE .noCarry		;/

	LDA #$0B			;\ Set to carried.
	STA !14C8,x			;/
	INC $1470|!addr
	LDA #$08
	STA $1498|!addr
	RTS

	.noCarry
	JSR MakeSolid
	.Ret
RTS

MakeSolid: 						; check out ($01AAB7)
	LDA !D8,x					;\ check to see if we are hitting the bottom 8 pixels of the sprite.
	SEC : SBC $D3				;|
	CLC : ADC #$08 : CMP #$20 	;|
	BCC PushPlayer				;| push out the player
	BPL HittingTop				;/ if the player is higher than that then push up
	LDA #$10					;\ push the player down, since the player's head is inside
	STA $7D						;/
	RTS
	HittingTop:
	LDA $7D						;\ if the player is already going up
	BMI Return					;/ just return
	STZ $7D						; zero out Y speed.
	STZ $72						;\ set the player to be on a solid sprite
	
	INC $1471|!addr				;/ $1471 is the ram address to see what type of solid sprite we are standing on.
	LDA #$1F					; how much to push up when not on yoshi
	LDY $187A|!addr
	BEQ notOnYoshi
	LDA #$2F					; how much to push up when on yoshi
	notOnYoshi:
	STA $00
	LDA !D8,x : SEC : SBC $00 : STA $96 ;\ push player on top of the sprite
	LDA !14D4,x : SBC #$00 : STA $97	;/
	asl !167A,x
	lsr !167A,x
	lda #$0B
	sta $1DF9|!addr
	lda $0DDA|!addr
	bmi +
	lda #$0E
	sta $1DFB|!addr
	+
	lda #$20
	sta !163E,x
	lsr !15F6,x
	asl !15F6,x
	ldy !151C,x
	lda #$B0
	sta $14AD|!addr,y
	lda #$20
	sta $1887|!addr
	cpy #$01
	bne Return
	jsl $02B9BD|!bank
	Return:
RTS

PushSpeed:					; How quickly to push ther player to either side of the key/P-switch.
	db $01,$00,$FF,$FF

PushPlayer: 				; $01AB31
	STZ $7B					; clear player X speed.
	%SubHorzPos()
	TYA
	ASL
	TAY
	REP #$20
	LDA $94
	CLC : ADC PushSpeed,y : STA $94
	SEP #$20
RTS

PointsSFX:					;$01A61E	| SFX for jumping on enemies in a row. Also for hits by a shell and by star power.
	db $13,$14,$15,$16,$17,$18,$19
GivePoints:					;Subroutine to get bounce sound effect and give points. Also used when bump-kicking shells.
	PHY							;
	LDA $1697|!addr				;\ 
	CLC							;|
	ADC !1626,x					;|
	INC $1697|!addr				;|
	TAY							;| Increase Mario's bounce counter and get bounce SFX.
	INY							;|
	CPY #$08					;|
	BCS CODE_01AB5D				;|
	LDA PointsSFX-1,Y			;|
	STA $1DF9|!addr				;/
	CODE_01AB5D:
	TYA
	CMP #$08					 
	BCC CODE_01AB64				
	LDA #$08
	CODE_01AB64:					
	JSL $02ACE5|!bank			; Give points
	PLY
RTS

BounceSpeed:								; Table which contains the bounce speed for carriable sprites when they hit the ground
	db $00,$00,$00,$F8,$F8,$F8,$F8,$F8
	db $F8,$F7,$F6,$F5,$F4,$F3,$F2,$E8
	db $E8,$E8,$E8,$00,$00,$00,$00,$FE		; sprites like goombas use the values starting at the $00s here.
	db $FC,$F8,$EC,$EC,$EC,$E8,$E4,$E0
	db $DC,$D8,$D4,$D0,$CC,$C8

; straight up yeeted from the all.log ($0197D5)
Bounce:					;| Subroutine to make carryable sprites bounce when they hit the ground.
	LDA !B6,x 
	PHP	
	BPL +
	EOR #$FF : INC A
	+		
	LSR				
	PLP				
	BPL +	
	EOR #$FF : INC A
	
	+		
	STA !B6,x
	LDA !AA,x					;\ 
	PHA							;| Set a normal ground Y speed.
	JSR SetSomeYSpeed			;/
	PLA
	LSR
	LSR
	TAY
	LDA BounceSpeed,y			;\ 
	LDY !1588,x					;| Get the Y speed to make the sprite bounce at when it hits the ground.
	BMI .Ret					;|
	STA !AA,x
	.Ret
RTS		

SetSomeYSpeed:					; Subroutine to set Y speed for a sprite when on the ground.
    LDA !1588,x                 ;\ See if the sprite on layer 2 
	BMI .onLayer2				;/ if it is then branch
	LDA #$00					; if not then set the Y speed to be 0
	LDY !15B8,x				    ; Check if we are on a slope
	BEQ .setYspeed				; if we are not then just set the speed
    .onLayer2
	LDA #$18
    .setYspeed	
	STA !AA,x
RTS	




; Yeeted from the all.log ($01999E)
InteractSideBlock:				; Subroutine for thrown sprites interacting with the sides of blocks.
	LDA #$01					;\ SFX for hitting a block with any sprite.
	STA $1DF9|!addr			;/
	JSR InvertDirSpeed			; Invert the sprite's X speed.
	LDA !15A0,x					;\ 
	BNE .offscreen				;|
	LDA !E4,x					;|
	SEC							;|
	SBC $1A						;|
	CLC							;|
	ADC #$14					;|
	CMP #$1C					;|
	BCC .offscreen				;|
	LDA !1588,x					;| If it's far enough on-screen, make it actually interact with the block.
	AND #$40					;|  i.e. this is the code that lets you actually hit a block with a thrown sprite.
	ASL							;|
	ASL							;|
	ROL							;|
	AND #$01					;|
	STA $1933|!addr				;|
	LDY #$00					;|
	LDA $18A7|!addr				;|
	JSL $00F160|!bank			;|
	LDA #$05					;|
	STA !1FE2,x					;/
	.offscreen:	
	; JSR Break
	.ret
RTS

InvertDirSpeed:
	LDA !B6,X		 
	EOR #$FF		
	INC A			
	STA !B6,X		
	LDA !SpriteDir,x
	EOR #$01		
	STA !SpriteDir,x
RTS

Break:
	STZ !14C8,x
	LDY #$FF
	LDA !15A0,x					;\ check if the sprite is offscreen.
	ORA !186C,x					;/
	BNE .Ret
	LDA !E4,x : STA $9A
	LDA !14E0,x : STA $9B
	LDA !D8,x : STA $98
	LDA !14D4,x : STA $99
	PHB
	LDA #$02
	PHA
	PLB
	TYA
	JSL $028663|!bank
	PLB
	.Ret
RTS

print "KICKED", pc
	JSR Kicked
RTL

;; !1528 is used to see as a flag to know if the kicked sprite has been caught by a blue koopa
;; Throw blocks set !1564 when its kicked by a blue koopa, used to disable sprite contact after being kicked by a blue koopa 
Kicked:
	LDA !1528,x								;\ check if the sprite got caught
	BNE .notslowedDown						;/
	
	LDA !B6,x : CLC : ADC #$20 : CMP #$40 : BCS .notslowedDown	; if the sprite some how slows down this much
	.notslowedDown
	STZ !1528,x
	LDA $9D
	BNE .draw
	
	JSR UpdateDirection
	LDA !15B8,x
	PHA
	JSL $01802A|!bank 				; update X and Y position, interact with objects and apply gravity.
	PLA
	BEQ .ongroundliquid

	STA $00
	LDA !164A,x
	BNE .ongroundliquid
	CMP !15B8,x					;\ Check if the sprite just got into a slope, 
	BEQ .ongroundliquid 		;/ if it didn't change then keep the same speed
	EOR !B6,x					;\ See if the sprite is going faster than the slope's angle
	BMI .ongroundliquid			;/ if not then don't make the sprite bounce slightly off the slope
	LDA #$F8					;\ Set the bounce here
	STA !AA,x					;/
	BRA +

	.ongroundliquid
	JSR IsOnGround
	BEQ .notOnGround
	JSR SetSomeYSpeed
	LDA #$10					; if this is set to #$0C  it will never fall thru one tile gaps and if set #$28 it will always fall in one tile gaps
	STA !AA,x
	+
	LDA $1860|!addr
	CMP #$B5
	BEQ .purpleTriangle
	CMP #$B4
	BNE .notOnGround
	
	.purpleTriangle
	LDA #$B8
	STA !AA,x
	
	.notOnGround
	JSR IsTouchingObjSide
	BEQ .noSide
	JSR InteractSideBlock
	
	.noSide
	JSR InteractionKicked
	.draw
	LDA #$00			;\
	%SubOffScreen()		;/ make sure of this
	JSR POWMain 
RTS

; feel free to change this interaction code to whatever you like.
InteractionKicked:    
  	JSL $01803A|!bank		; interact with player and other sprites.
  	bcc .Ret
	LDA !DisableContact,x
	BNE .Ret
	JSR MakeSolid
	.Ret			
RTS							



; interesting routine that updates sprite's direction based on its X speed
UpdateDirection:
	LDA.b #$00		
	LDY !B6,x		
	BEQ .Ret		
	BPL .changeDir	
	INC A			
	.changeDir
	STA !SpriteDir,x
	.Ret				
RTS				

CarryXLow: 			db $0B, $F5, $04, $FC, $04, $00
CarryXHigh: 		db $00, $FF, $00, $FF, $00, $00

DropXOffsetLow: 	db $F3, $0D 			; how far off Mario will the sprite drop (format: right, left)
DropXOffsetHigh: 	db $FF, $00

DropXSpeed:  		db $FC, $04  			; the X speed at which the sprite will drop (format: right, left)

KickXSpeed:			db $D2, $2E, $CC, $34	; X Speed when the sprite is kicked, 3rd and 4th values are the speed given when the sprite is spat out of yoshi's mouth.


print "CARRIED", pc
	JSR Carried
	LDA $13DD|!addr			;\ Check if player is turining around
	BNE .infrontOfPlayer	;/

	LDA $1419|!addr			;\ check if going in a pipe
	BNE .infrontOfPlayer	;/

	LDA $1499|!addr			;\ check if the face the screen timer is set
	BEQ +					;/ if not then no need to zero out OAM index.
	
	.infrontOfPlayer
	STZ !15EA,x 			; Zero out OAM slot so the sprite can appear infront of the player.
	+
	LDA $64
	PHA
	LDA $1419|!addr
	BEQ .draw
	LDA #$10		;\ if going in a pipe then just make sure the tile is behind the object.
	STA $64			;/ (its your duty to make the graphics routine use $64.)
	.draw
	JSR POWMain
	PLA
	STA $64
RTL

Carried:
    JSL $019138|!bank      	; interact with objects
    LDA $71                 ;\ if not powering up or down, entering pipe, etc
    CMP #$01                ;| then just skip over this
    BCC +                   ;/
    LDA $1419|!addr
    BNE +

    LDA #$09                ;\ Make the sprite carriable
    STA !14C8,x             ;/
    RTS
    
    +

    LDA $9D					;\ game is frozen so just offset the sprite.0
    BNE .justoffset			;/

    JSL $018032|!bank	; Interact with other sprites.
    LDA $1419|!addr   	;\ if player is going in a pipe then just offset the sprite
    BNE .justoffset     ;/
    BIT $15             ;\ if X/Y arent pressed just let go.
    BVC LetGo           ;/
	  .justoffset
    JSR OffsetSprite
RTS

LetGo:
    STZ !1626,x
    LDY #$00    			; put the Y speed for when letting go of the sprite in Y.
    
    STY !AA,x

	LDA #$09				;\ Set the sprite to be carriable
	STA !14C8,x				;/

	LDA $15					;\ check if up is being pressed
	AND #$08				;|
	BNE Up					;/
	

	LDA $15					;\ Check if left/right is pressed
	AND #$03				;|
	BNE SideWays			;/ if not not then drop the sprite

Drop:
	LDY $76												;\ move X position of the sprite .
	LDA $D1 : CLC : ADC DropXOffsetLow,y : STA !E4,x	;|
	LDA $D2 : ADC DropXOffsetHigh,y : STA !14E0,x		;/
	%SubHorzPos()
	LDA DropXSpeed,y : CLC : ADC $7B : STA !B6,x 		; set some X speed for dropping the sprite
	STZ !AA,x											; no Y speed.
	BRA DisableContact									; done with dropping so disable contact.

SideWays:
	JSL $01AB6F|!bank				; show the contact.
	; LDA !1540,x					;\ It seems like carryable sprites save their stun timer to !C2 when they are kicked
	; STA !C2,x						;/ commenting this out just incase you are using !C2 and you don't want it to be messed up anywhere.
	LDA #$0A
	STA !14C8,x
	LDY $76
	LDA $187A|!addr
	BEQ .notRidingYoshi
	INY #2
	.notRidingYoshi
	LDA KickXSpeed,y
	STA !B6,x
	EOR $7B
	BMI DisableContact					; not moving in the same direction as the player so just disable contact
	LDA $7B								;\ Moving in the same direction so
	STA $00								;| half the player's speed and add it to the sprite's speed.
	ASL $00								;|
	ROR									;/
	CLC : ADC KickXSpeed,y : STA !B6,x

DisableContact:
	LDA #!DisableContactFrames	;\ how many frames to disable contact with the player.
	STA !DisableContact,x		;/

	LDA #$0C					;\ show the kicking pose
	STA $149A|!addr				;/
RTS

;; Code that is ran when X/Y are let go and the up button is being pressed..
Up:
	JSL $01AB6F|!bank			; show the contact.
	LDA #$90					;\ Up kicked Y speed.
	STA !AA,x					;/

	LDA $7B						;\
	STA !B6,x					;|
	ASL							;|
	ROR !B6,x					;/ Sprite gets half of the player's X speed.
	BRA DisableContact


; Credit to KevinM KoopaShell disassembly for the OffsetSprite routine
; Right, left, left while turning, right when turning, sliding/going down a pipe/climbing while turning, centered.
OffsetSprite:
	LDA $13E0|!addr 	;\ if the player is in the dying animation
	CMP #$3E 	        ;| then there is no need to offset 
	BNE ++ 		        ;/ the sprite to be where the player is at
    RTS

	++
    LDA $76 			;\ 00 = left, 01 = right so need to flip for our table
	EOR #$01 			;| will be used as index to the CarryXoffset
	TAY 				;/
	STA !SpriteDir,x
	LDA $1499|!addr 	; Timer for player to face the screen
	BEQ +
	INY #2				; this puts us at index 2 if the player is facing right 3 if facing left
	CMP #$05 			; if $1499|!addr is set to #$05 then that we need to increment once more.
	BCC +
	INY 				; Y now should be 3 if facing right or 4 if facing left
	
	+
	LDA $1419|!addr 	; going through a pipe (for yoshi)
	BEQ + 				; not going through pipe so we skip
	CMP #$02  			; if we are facing the screen then we just set Y to be 5
	BEQ ++
	
	+
 	LDA $13DD|!addr 	; Pose used while the player is on the ground and turning around with a non-zero X speed. 
	ORA $74 			; or if the player is carrying an item while being on the net then we center the carryable sprite
	BEQ +++ 			; if neither we just branch
	
	++
 	LDY #$05 			; set index to be #$05
	
	+++
 	PHY 				; save our index to get later
	LDY #$00
	LDA $1471|!addr
	CMP #$03 
	BEQ +
	LDY #$3D 			; if calculated using current frame then we use #$3D else #$00 is used
	
	+
 	LDA $94,y			;\ Player X pos low byte
	STA $00				;/

	LDA $95,y 			;\ Player X pos high byte
	STA $01 			;/

	LDA $96,y 			;\ Player Y pos low byte
	STA $02 			;/

	LDA $97,y 			;\ Player Y pos high byte
	STA $03 			;/
	PLY

	LDA $00 				;\
	CLC : ADC CarryXLow,y 	;| Setting the sprite X low byte offset from the player while carrying 
	STA !E4,x 				;/

	LDA $01					;\
	ADC CarryXHigh,y		;| Setting the sprite X high byte offset from the player while carrying 
	STA !14E0,x				;/

	LDA #$0D 				; Player's Y offset when they are big
	LDY $73 				; load player is ducking flag
	BNE +
	LDY $19					; if the player is big then Y #$0D offset is used
	BNE ++ 
 	
	+ 	
 	LDA #$0F				; if player is small or ducking then the offset is set to #$0F

 	++ 
 	LDY $1498|!addr
	BEQ +
	LDA #$0F

 	+ 	
 	CLC : ADC $02 			;\ add Y offset to Player's Y position and 
	STA !D8,x 				;/ store it to low byte Y pos of sprite

	LDA $03
	ADC #$00 			    ;\ add Y offset to Player's Y position and 
	STA !14D4,x 			;/ store it to low byte Y pos of sprite

	LDA #$01 				;\ Set carry flag and carried animation flag.
	STA $1470|!addr 		;|
	STA $148F|!addr 		;/
RTS

; could just have them as routine but ye.
IsTouchingObjSide:				
	LDA !1588,X
	AND #$03
RTS

IsOnGround:
	LDA !1588,X
	AND #$04	
RTS			

IsTouchingCeiling:
	LDA !1588,X
	AND #$08	
RTS

Graphics:
    %GetDrawInfo()
    LDA $00
    STA $0300|!addr,y
    LDA $01
    STA $0301|!addr,y
	lda #!GFXTile
    STA $0302|!addr,y
    LDA !15F6,x
    ORA $64
    STA $0303|!addr,y
    LDA #$00 				; A = (number of tiles drawn - 1)
    LDY #$02 				; 16x16 tiles
	JSL $01B7B3|!bank 		; don't draw if offscreen
RTS

SmushedGFX:
	%GetDrawInfo()
	lda $00
    sta $0300|!addr,y
	clc : adc #$08
	sta $0304|!addr,y
	lda $01
	clc : adc #$08
	sta $0301|!addr,y
	sta $0305|!addr,y
	lda #!SmushedGFXTile
	sta $0302|!addr,y
	sta $0306|!addr,y
	lda $64
	ora !15F6,x
	sta $0303|!addr,y
	ora #$40
	sta $0307|!addr,y
	tya
	lsr #2
	tay
	lda #$00
	sta $0460|!addr,y
	sta $0461|!addr,y
rts


